/*
 * Decompiled with CFR 0.152.
 */
package io.neox.neonium;

import me.jellysquid.mods.sodium.common.config.EarlyModDetection;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LittleTilesCompat {
    private static final Logger LOGGER = LogManager.getLogger((String)"LittleTilesCompat");
    private static boolean initialized = false;
    private static boolean littleTilesDetected = false;

    public static boolean isLittleTilesLoaded() {
        if (initialized) {
            return littleTilesDetected;
        }
        if (EarlyModDetection.isLittleTilesPresent()) {
            initialized = true;
            littleTilesDetected = true;
            LOGGER.info("Using early detection result for LittleTiles: FOUND");
            return true;
        }
        try {
            if (Loader.instance() != null) {
                littleTilesDetected = Loader.isModLoaded((String)"littletiles");
                initialized = true;
                if (littleTilesDetected) {
                    LOGGER.info("LittleTiles detected via Forge Loader!");
                }
                return littleTilesDetected;
            }
            try {
                Class<?> littleTilesClass = Class.forName("com.creativemd.littletiles.LittleTiles", false, LittleTilesCompat.class.getClassLoader());
                if (littleTilesClass != null) {
                    LOGGER.info("LittleTiles detected via direct class check!");
                    littleTilesDetected = true;
                    initialized = true;
                    return true;
                }
            }
            catch (ClassNotFoundException littleTilesClass) {
                // empty catch block
            }
            littleTilesDetected = EarlyModDetection.isLittleTilesPresent();
            initialized = true;
            return littleTilesDetected;
        }
        catch (Throwable t) {
            LOGGER.debug("Error checking for LittleTiles mod via Forge, using early detection result", t);
            littleTilesDetected = EarlyModDetection.isLittleTilesPresent();
            initialized = true;
            return littleTilesDetected;
        }
    }

    public static void initialize() {
        LittleTilesCompat.isLittleTilesLoaded();
    }
}

